"""Runner script that tests your solution. Do not edit this file."""

import io
import logging
import runpy
from contextlib import redirect_stdout
from pathlib import Path

from safe_exec import EvalBlockedError, ExecBlockedError, safe

logging.basicConfig(level=logging.INFO)

with safe(exec), safe(eval):
    output = io.StringIO()
    try:
        with redirect_stdout(output):
            runpy.run_path(str(Path(__file__).parent / "solution.py"))
    except (ExecBlockedError, EvalBlockedError) as exc:
        print("Blocked exec/eval call!")
        print(f"Globals: {exc.globals}")
        print(f"Locals: {exc.locals}")
        print(f"Blocked code: {exc.source!r}")
        print(f"Caller: {exc.caller.co_name}")
    else:
        print("No exec/eval calls were blocked.")
    print(f"Output: {output.getvalue()}")
